define(function(require) {

require("./math-format.js");

$.fn["chemistryLoad"] = function() {
    // TODO(jeresig): i18n: Currently the names of the atomic elements aren't
    // being used in the UI, but if they are, they will need to be translated.
    var elements = {
        "Hydrogen": {
            "symbol" : "H",
            "atomic_number" : 1,
            "atomic_weight" : 1.00794,
            "density g/cm" : "0.0708 (@ -253°C)",
            "melting_point K" : 14.01,
            "boiling_point K" : 20.28,
            "atomic_radius pm" : 79,
            "covalent_radius pm" : 32,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 14.1,
            "specific_heat (@20°C J/g mol)" : "14.267 (H-H)",
            "fusion_heat (kJ/mol)" : "0.117 (H-H)",
            "evaporation_heat (kJ/mol)" : "0.904 (H-H)",
            "thermal_conductivity (@25°C W/m K) " : 0.1815,
            "pauling_negativity" : 2.20,
            "first_ionizing kJ/mol" : 1311.3,
            "oxidation_states" : "1, -1",
            "electronic_configuration" : "1s¹",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.750
        },
        "Helium": {
            "symbol" : "He",
            "atomic_number" : 2,
            "atomic_weight" : 4.002602,
            "density g/cm" : "0.147 (@ -270°C)",
            "melting_point K" : 0.95,
            "boiling_point K" : 4.216,
            "atomic_radius pm" : 0.0,
            "covalent_radius pm" : "-",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 31.8,
            "specific_heat (@20°C J/g mol)" : 5.188,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 0.08,
            "thermal_conductivity (@25°C W/m K) " : 0.152,
            "pauling_negativity" : "-",
            "first_ionizing kJ/mol" : 2361.3,
            "oxidation_states" : "-",
            "electronic_configuration" : "1s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.570
        },
        "Lithium": {
            "symbol" : "Li",
            "atomic_number" : 3,
            "atomic_weight" : 6.941,
            "density g/cm" : 0.534,
            "melting_point K" : 553.69,
            "boiling_point K" : 1118.15,
            "atomic_radius pm" : 155,
            "covalent_radius pm" : 163,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 13.1,
            "specific_heat (@20°C J/g mol)" : 3.489,
            "fusion_heat (kJ/mol)" : 2.89,
            "evaporation_heat (kJ/mol)" : 148,
            "thermal_conductivity (@25°C W/m K) " : 84.8,
            "pauling_negativity" : 0.98,
            "first_ionizing kJ/mol" : 519.9,
            "oxidation_states" : 1,
            "electronic_configuration" : "[He]2s¹",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : 3.490
        },
        "Beryllium": {
            "symbol" : "Be",
            "atomic_number" : 4,
            "atomic_weight" : 9.01218,
            "density g/cm" : 1.848,
            "melting_point K" : 1551,
            "boiling_point K" : 3243,
            "atomic_radius pm" : 112,
            "covalent_radius pm" : 90,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 5.0,
            "specific_heat (@20°C J/g mol)" : 1.824,
            "fusion_heat (kJ/mol)" : 12.21,
            "evaporation_heat (kJ/mol)" : 309,
            "thermal_conductivity (@25°C W/m K) " : 201,
            "pauling_negativity" : 1.57,
            "first_ionizing kJ/mol" : 898.8,
            "oxidation_states" : 2,
            "electronic_configuration" : "[He]2s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 2.290
        },
        "Boron": {
            "symbol" : "B",
            "atomic_number" : 5,
            "atomic_weight" : 10.811,
            "density g/cm" : 2.34,
            "melting_point K" : 2573,
            "boiling_point K" : 3931,
            "atomic_radius pm" : 98,
            "covalent_radius pm" : 82,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 4.6,
            "specific_heat (@20°C J/g mol)" : 1.025,
            "fusion_heat (kJ/mol)" : 23.60,
            "evaporation_heat (kJ/mol)" : 504.5,
            "thermal_conductivity (@25°C W/m K) " : 27.4,
            "pauling_negativity" : 2.04,
            "first_ionizing kJ/mol" : 800.2,
            "oxidation_states" : 3,
            "electronic_configuration" : "[He]2s²2p¹",
            "lattice_structure" : "TET",
            "lattice_constant ang" : 8.730
        },
        "Carbon": {
            "symbol" : "C",
            "atomic_number" : 6,
            "atomic_weight" : 12.011,
            "density g/cm" : "2.25 (graphite)",
            "melting_point K" : 3820,
            "boiling_point K" : 5100,
            "atomic_radius pm" : 91,
            "covalent_radius pm" : 77,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 5.3,
            "specific_heat (@20°C J/g mol)" : 0.711,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : "-",
            "thermal_conductivity (@25°C W/m K) " : 1.59,
            "pauling_negativity" : 2.55,
            "first_ionizing kJ/mol" : 1085.7,
            "oxidation_states" : "4, 2, -4",
            "electronic_configuration" : "[He]2s²2p²",
            "lattice_structure" : "DIA",
            "lattice_constant ang" : 3.570
        },
        "Nitrogen": {
            "symbol" : "N",
            "atomic_number" : 7,
            "atomic_weight" : 14.00674,
            "density g/cm" : "0.808 (@ -195.8°C)",
            "melting_point K" : 63.29,
            "boiling_point K" : 77.4,
            "atomic_radius pm" : 92,
            "covalent_radius pm" : 75,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 17.3,
            "specific_heat (@20°C J/g mol)" : "1.042 (N-N)",
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : "-",
            "thermal_conductivity (@25°C W/m K) " : 0.026,
            "pauling_negativity" : 3.04,
            "first_ionizing kJ/mol" : 1401.5,
            "oxidation_states" : "5, 4, 3, 2, -3",
            "electronic_configuration" : "[He]2s²2p³",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 4.039
        },
        "Oxygen": {
            "symbol" : "O",
            "atomic_number" : 8,
            "atomic_weight" : 15.9994,
            "density g/cm" : "1.149 (@ -183°C)",
            "melting_point K" : 54.8,
            "boiling_point K" : 90.19,
            "atomic_radius pm" : "-",
            "covalent_radius pm" : 73,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 14.0,
            "specific_heat (@20°C J/g mol)" : "0.916 (O-O)",
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : "-",
            "thermal_conductivity (@25°C W/m K) " : 0.027,
            "pauling_negativity" : 3.44,
            "first_ionizing kJ/mol" : 1313.1,
            "oxidation_states" : "-2, -1",
            "electronic_configuration" : "[He]2s²2p",
            "lattice_structure" : "CUB",
            "lattice_constant ang" : 6.830
        },
        "Fluorine": {
            "symbol" : "F",
            "atomic_number" : 9,
            "atomic_weight" : 18.998403,
            "density g/cm" : "1.108 (@ -189°C)",
            "melting_point K" : 53.53,
            "boiling_point K" : 85.01,
            "atomic_radius pm" : "-",
            "covalent_radius pm" : 72,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 17.1,
            "specific_heat (@20°C J/g mol)" : "0.824 (F-F)",
            "fusion_heat (kJ/mol)" : "0.51 (F-F)",
            "evaporation_heat (kJ/mol)" : "6.54 (F-F)",
            "thermal_conductivity (@25°C W/m K) " : 0.028,
            "pauling_negativity" : 3.98,
            "first_ionizing kJ/mol" : 1680.0,
            "oxidation_states" : -1,
            "electronic_configuration" : "[He]2s²2p",
            "lattice_structure" : "MCL",
            "lattice_constant ang" : "-"
        },
        "Neon": {
            "symbol" : "Ne",
            "atomic_number" : 10,
            "atomic_weight" : 20.1797,
            "density g/cm" : "1.204 (@ -246°C)",
            "melting_point K" : 48,
            "boiling_point K" : 27.1,
            "atomic_radius pm" : "-",
            "covalent_radius pm" : 71,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 16.8,
            "specific_heat (@20°C J/g mol)" : 1.029,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 1.74,
            "thermal_conductivity (@25°C W/m K) " : "(0.0493)",
            "pauling_negativity" : 0.0,
            "first_ionizing kJ/mol" : 2079.4,
            "oxidation_states" : "-",
            "electronic_configuration" : "[He]2s²2p",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 4.430
        },
        "Sodium": {
            "symbol" : "Na",
            "atomic_number" : 11,
            "atomic_weight" : 22.989768,
            "density g/cm" : 0.971,
            "melting_point K" : 370.96,
            "boiling_point K" : 1156.1,
            "atomic_radius pm" : 190,
            "covalent_radius pm" : 154,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 23.7,
            "specific_heat (@20°C J/g mol)" : 1.222,
            "fusion_heat (kJ/mol)" : 2.64,
            "evaporation_heat (kJ/mol)" : 97.9,
            "thermal_conductivity (@25°C W/m K) " : 142.0,
            "pauling_negativity" : 0.93,
            "first_ionizing kJ/mol" : 495.6,
            "oxidation_states" : 1,
            "electronic_configuration" : "[Ne]3s¹",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : 4.230
        },
        "Magnesium": {
            "symbol" : "Mg",
            "atomic_number" : 12,
            "atomic_weight" : 24.305,
            "density g/cm" : 1.738,
            "melting_point K" : 922,
            "boiling_point K" : 1363,
            "atomic_radius pm" : 160,
            "covalent_radius pm" : 136,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 14.0,
            "specific_heat (@20°C J/g mol)" : 1.025,
            "fusion_heat (kJ/mol)" : 9.20,
            "evaporation_heat (kJ/mol)" : 131.8,
            "thermal_conductivity (@25°C W/m K) " : 156,
            "pauling_negativity" : 1.31,
            "first_ionizing kJ/mol" : 737.3,
            "oxidation_states" : 2,
            "electronic_configuration" : "[Ne]3s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.210
        },
        "Aluminum": {
            "symbol" : "Al",
            "atomic_number" : 13,
            "atomic_weight" : 26.981539,
            "density g/cm" : 2.6989,
            "melting_point K" : 933.5,
            "boiling_point K" : 2740,
            "atomic_radius pm" : 143,
            "covalent_radius pm" : 118,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 10.0,
            "specific_heat (@20°C J/g mol)" : 0.900,
            "fusion_heat (kJ/mol)" : 10.75,
            "evaporation_heat (kJ/mol)" : 284.1,
            "thermal_conductivity (@25°C W/m K) " : 237,
            "pauling_negativity" : 1.61,
            "first_ionizing kJ/mol" : 577.2,
            "oxidation_states" : 3,
            "electronic_configuration" : "[Ne]3s²3p¹",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 4.050
        },
        "Silicon": {
            "symbol" : "Si",
            "atomic_number" : 14,
            "atomic_weight" : 28.0855,
            "density g/cm" : 2.33,
            "melting_point K" : 1683,
            "boiling_point K" : 2628,
            "atomic_radius pm" : 132,
            "covalent_radius pm" : 111,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 12.1,
            "specific_heat (@20°C J/g mol)" : 0.703,
            "fusion_heat (kJ/mol)" : 50.6,
            "evaporation_heat (kJ/mol)" : 383,
            "thermal_conductivity (@25°C W/m K) " : 149,
            "pauling_negativity" : 1.90,
            "first_ionizing kJ/mol" : 786.0,
            "oxidation_states" : "4, -4",
            "electronic_configuration" : "[Ne]3s²3p²",
            "lattice_structure" : "DIA",
            "lattice_constant ang" : 5.430
        },
        "Phosphorus": {
            "symbol" : "P",
            "atomic_number" : 15,
            "atomic_weight" : 30.973762,
            "density g/cm" : "1.82 (white phosphorus)",
            "melting_point K" : 317.3,
            "boiling_point K" : 553,
            "atomic_radius pm" : 128,
            "covalent_radius pm" : 106,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 17.0,
            "specific_heat (@20°C J/g mol)" : 0.757,
            "fusion_heat (kJ/mol)" : 2.51,
            "evaporation_heat (kJ/mol)" : 49.8,
            "thermal_conductivity (@25°C W/m K) " : "(0.236)",
            "pauling_negativity" : 2.19,
            "first_ionizing kJ/mol" : 1011.2,
            "oxidation_states" : "5, 3, -3",
            "electronic_configuration" : "[Ne]3s²3p³",
            "lattice_structure" : "CUB",
            "lattice_constant ang" : 7.170
        },
        "Sulfur": {
            "symbol" : "S",
            "atomic_number" : 16,
            "atomic_weight" : 32.066,
            "density g/cm" : 2.070,
            "melting_point K" : 386,
            "boiling_point K" : 717.824,
            "atomic_radius pm" : 127,
            "covalent_radius pm" : 102,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 15.5,
            "specific_heat (@20°C J/g mol)" : 0.732,
            "fusion_heat (kJ/mol)" : 1.23,
            "evaporation_heat (kJ/mol)" : 10.5,
            "thermal_conductivity (@25°C W/m K) " : 0.27,
            "pauling_negativity" : 2.58,
            "first_ionizing kJ/mol" : 999.0,
            "oxidation_states" : "6, 4, 2, -2",
            "electronic_configuration" : "[Ne]3s²3p",
            "lattice_structure" : "ORC",
            "lattice_constant ang" : 10.470
        },
        "Chlorine": {
            "symbol" : "Cl",
            "atomic_number" : 17,
            "atomic_weight" : 35.4527,
            "density g/cm" : "1.56 (@ -33.6°C)",
            "melting_point K" : 172.2,
            "boiling_point K" : 238.6,
            "atomic_radius pm" : "-",
            "covalent_radius pm" : 99,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 18.7,
            "specific_heat (@20°C J/g mol)" : "0.477 (Cl-Cl)",
            "fusion_heat (kJ/mol)" : "6.41 (Cl-Cl)",
            "evaporation_heat (kJ/mol)" : "20.41 (Cl-Cl)",
            "thermal_conductivity (@25°C W/m K) " : 0.009,
            "pauling_negativity" : 3.16,
            "first_ionizing kJ/mol" : 1254.9,
            "oxidation_states" : "7, 5, 3, 1, -1",
            "electronic_configuration" : "[Ne]3s²3p",
            "lattice_structure" : "ORC",
            "lattice_constant ang" : 6.240
        },
        "Argon": {
            "symbol" : "Ar",
            "atomic_number" : 18,
            "atomic_weight" : 39.948,
            "density g/cm" : "1.40 (@ -186°C)",
            "melting_point K" : 83.8,
            "boiling_point K" : 87.3,
            "atomic_radius pm" : "2-",
            "covalent_radius pm" : 98,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 24.2,
            "specific_heat (@20°C J/g mol)" : 0.138,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 6.52,
            "thermal_conductivity (@25°C W/m K) " : 0.0177,
            "pauling_negativity" : 0.0,
            "first_ionizing kJ/mol" : 1519.6,
            "oxidation_states" : "-",
            "electronic_configuration" : "[Ne]3s²3p",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 5.260
        },
        "Potassium": {
            "symbol" : "K",
            "atomic_number" : 19,
            "atomic_weight" : 39.0983,
            "density g/cm" : 0.856,
            "melting_point K" : 336.8,
            "boiling_point K" : 1047,
            "atomic_radius pm" : 235,
            "covalent_radius pm" : 203,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 45.3,
            "specific_heat (@20°C J/g mol)" : 0.753,
            "fusion_heat (kJ/mol)" : 102.5,
            "evaporation_heat (kJ/mol)" : 2.33,
            "thermal_conductivity (@25°C W/m K) " : 79.0,
            "pauling_negativity" : 0.82,
            "first_ionizing kJ/mol" : 418.5,
            "oxidation_states" : 1,
            "electronic_configuration" : "[Ar]4s¹",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : 5.230
        },
        "Calcium": {
            "symbol" : "Ca",
            "atomic_number" : 20,
            "atomic_weight" : 40.078,
            "density g/cm" : 1.55,
            "melting_point K" : 1112,
            "boiling_point K" : 1757,
            "atomic_radius pm" : 197,
            "covalent_radius pm" : 174,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 29.9,
            "specific_heat (@20°C J/g mol)" : 0.653,
            "fusion_heat (kJ/mol)" : 9.20,
            "evaporation_heat (kJ/mol)" : 153.6,
            "thermal_conductivity (@25°C W/m K) " : "(201)",
            "pauling_negativity" : 1.00,
            "first_ionizing kJ/mol" : 589.4,
            "oxidation_states" : 2,
            "electronic_configuration" : "[Ar]4s²",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 5.580
        },
        "Scandium": {
            "symbol" : "Sc",
            "atomic_number" : 21,
            "atomic_weight" : 44.95591,
            "density g/cm" : 2.99,
            "melting_point K" : 1814,
            "boiling_point K" : 3104,
            "atomic_radius pm" : 162,
            "covalent_radius pm" : 144,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 15.0,
            "specific_heat (@20°C J/g mol)" : 0.556,
            "fusion_heat (kJ/mol)" : 15.8,
            "evaporation_heat (kJ/mol)" : 332.7,
            "thermal_conductivity (@25°C W/m K) " : 15.8,
            "pauling_negativity" : 1.36,
            "first_ionizing kJ/mol" : 630.8,
            "oxidation_states" : 3,
            "electronic_configuration" : "[Ar]3d¹4s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.310
        },
        "Titanium": {
            "symbol" : "Ti",
            "atomic_number" : 22,
            "atomic_weight" : 47.88,
            "density g/cm" : 4.54,
            "melting_point K" : 1933,
            "boiling_point K" : 3560,
            "atomic_radius pm" : 147,
            "covalent_radius pm" : 132,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 10.6,
            "specific_heat (@20°C J/g mol)" : 0.523,
            "fusion_heat (kJ/mol)" : 18.8,
            "evaporation_heat (kJ/mol)" : 422.6,
            "thermal_conductivity (@25°C W/m K) " : 21.9,
            "pauling_negativity" : 1.54,
            "first_ionizing kJ/mol" : 657.8,
            "oxidation_states" : "4, 3",
            "electronic_configuration" : "[Ar]3d²4s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 2.950
        },
        "Vanadium": {
            "symbol" : "V",
            "atomic_number" : 23,
            "atomic_weight" : 50.9415,
            "density g/cm" : 6.11,
            "melting_point K" : 2160,
            "boiling_point K" : 3650,
            "atomic_radius pm" : 134,
            "covalent_radius pm" : 122,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 8.35,
            "specific_heat (@20°C J/g mol)" : 0.485,
            "fusion_heat (kJ/mol)" : 17.5,
            "evaporation_heat (kJ/mol)" : 460,
            "thermal_conductivity (@25°C W/m K) " : 30.7,
            "pauling_negativity" : 1.63,
            "first_ionizing kJ/mol" : 650.1,
            "oxidation_states" : "5, 4, 3, 2, 0",
            "electronic_configuration" : "[Ar]3d³4s²",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : 3.020
        },
        "Chromium": {
            "symbol" : "Cr",
            "atomic_number" : 24,
            "atomic_weight" : 51.9961,
            "density g/cm" : 7.18,
            "melting_point K" : 2130,
            "boiling_point K" : 2945,
            "atomic_radius pm" : 130,
            "covalent_radius pm" : 118,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 7.23,
            "specific_heat (@20°C J/g mol)" : 0.488,
            "fusion_heat (kJ/mol)" : 21,
            "evaporation_heat (kJ/mol)" : 342,
            "thermal_conductivity (@25°C W/m K) " : 93.9,
            "pauling_negativity" : 1.66,
            "first_ionizing kJ/mol" : 652.4,
            "oxidation_states" : "6, 3, 2, 0",
            "electronic_configuration" : "[Ar]3d4s¹",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : 2.880
        },
        "Manganese": {
            "symbol" : "Mn",
            "atomic_number" : 25,
            "atomic_weight" : 54.93805,
            "density g/cm" : 7.21,
            "melting_point K" : 1517,
            "boiling_point K" : 2235,
            "atomic_radius pm" : 135,
            "covalent_radius pm" : 117,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 7.39,
            "specific_heat (@20°C J/g mol)" : 0.477,
            "fusion_heat (kJ/mol)" : "(13.4)",
            "evaporation_heat (kJ/mol)" : 221,
            "thermal_conductivity (@25°C W/m K) " : "(7.8)",
            "pauling_negativity" : 1.55,
            "first_ionizing kJ/mol" : 716.8,
            "oxidation_states" : "7, 6, 4, 3, 2, 0, -1",
            "electronic_configuration" : "[Ar]3d4s²",
            "lattice_structure" : "CUB",
            "lattice_constant ang" : 8.890
        },
        "Iron": {
            "symbol" : "Fe",
            "atomic_number" : 26,
            "atomic_weight" : 55.847,
            "density g/cm" : 7.874,
            "melting_point K" : 1808,
            "boiling_point K" : 3023,
            "atomic_radius pm" : 126,
            "covalent_radius pm" : 117,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 7.1,
            "specific_heat (@20°C J/g mol)" : 0.443,
            "fusion_heat (kJ/mol)" : 13.8,
            "evaporation_heat (kJ/mol)" : "~340",
            "thermal_conductivity (@25°C W/m K) " : 80.4,
            "pauling_negativity" : 1.83,
            "first_ionizing kJ/mol" : 759.1,
            "oxidation_states" : "6, 3, 2, 0, -2",
            "electronic_configuration" : "[Ar]3d4s²",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : 2.870
        },
        "Cobalt": {
            "symbol" : "Co",
            "atomic_number" : 27,
            "atomic_weight" : 58.9332,
            "density g/cm" : 8.9,
            "melting_point K" : 1768,
            "boiling_point K" : 3143,
            "atomic_radius pm" : 125,
            "covalent_radius pm" : 116,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 6.7,
            "specific_heat (@20°C J/g mol)" : 0.456,
            "fusion_heat (kJ/mol)" : 15.48,
            "evaporation_heat (kJ/mol)" : 389.1,
            "thermal_conductivity (@25°C W/m K) " : 100,
            "pauling_negativity" : 1.88,
            "first_ionizing kJ/mol" : 758.1,
            "oxidation_states" : "3, 2, 0, -1",
            "electronic_configuration" : "[Ar]3d4s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 2.510
        },
        "Nickel": {
            "symbol" : "Ni",
            "atomic_number" : 28,
            "atomic_weight" : 58.6934,
            "density g/cm" : 8.902,
            "melting_point K" : 1726,
            "boiling_point K" : 3005,
            "atomic_radius pm" : 124,
            "covalent_radius pm" : 115,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 6.6,
            "specific_heat (@20°C J/g mol)" : 0.443,
            "fusion_heat (kJ/mol)" : 17.61,
            "evaporation_heat (kJ/mol)" : 378.6,
            "thermal_conductivity (@25°C W/m K) " : 90.9,
            "pauling_negativity" : 1.91,
            "first_ionizing kJ/mol" : 736.2,
            "oxidation_states" : "3, 2, 0",
            "electronic_configuration" : "[Ar]3d4s²",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 3.520
        },
        "Copper": {
            "symbol" : "Cu",
            "atomic_number" : 29,
            "atomic_weight" : 63.546,
            "density g/cm" : 8.96,
            "melting_point K" : 1356.6,
            "boiling_point K" : 2840,
            "atomic_radius pm" : 128,
            "covalent_radius pm" : 117,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 7.1,
            "specific_heat (@20°C J/g mol)" : 0.385,
            "fusion_heat (kJ/mol)" : 13.01,
            "evaporation_heat (kJ/mol)" : 304.6,
            "thermal_conductivity (@25°C W/m K) " : 401,
            "pauling_negativity" : 1.90,
            "first_ionizing kJ/mol" : 745.0,
            "oxidation_states" : "2, 1",
            "electronic_configuration" : "[Ar]3d¹4s¹",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 3.610
        },
        "Zinc": {
            "symbol" : "Zn",
            "atomic_number" : 30,
            "atomic_weight" : 65.39,
            "density g/cm" : 7.133,
            "melting_point K" : 692.73,
            "boiling_point K" : 1180,
            "atomic_radius pm" : 138,
            "covalent_radius pm" : 125,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 9.2,
            "specific_heat (@20°C J/g mol)" : 0.388,
            "fusion_heat (kJ/mol)" : 7.28,
            "evaporation_heat (kJ/mol)" : 114.8,
            "thermal_conductivity (@25°C W/m K) " : 116,
            "pauling_negativity" : 1.65,
            "first_ionizing kJ/mol" : 905.8,
            "oxidation_states" : 2,
            "electronic_configuration" : "[Ar]3d¹4s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 2.660
        },
        "Gallium": {
            "symbol" : "Ga",
            "atomic_number" : 31,
            "atomic_weight" : 69.723,
            "density g/cm" : 5.91,
            "melting_point K" : 302.93,
            "boiling_point K" : 2676,
            "atomic_radius pm" : 141,
            "covalent_radius pm" : 126,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 11.8,
            "specific_heat (@20°C J/g mol)" : 0.372,
            "fusion_heat (kJ/mol)" : 5.59,
            "evaporation_heat (kJ/mol)" : 270.3,
            "thermal_conductivity (@25°C W/m K) " : 28.1,
            "pauling_negativity" : 1.81,
            "first_ionizing kJ/mol" : 578.7,
            "oxidation_states" : 3,
            "electronic_configuration" : "[Ar]3d¹4s²4p¹",
            "lattice_structure" : "ORC",
            "lattice_constant ang" : 4.510
        },
        "Germanium": {
            "symbol" : "Ge",
            "atomic_number" : 32,
            "atomic_weight" : 72.61,
            "density g/cm" : 5.323,
            "melting_point K" : 1210.6,
            "boiling_point K" : 3103,
            "atomic_radius pm" : 137,
            "covalent_radius pm" : 122,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 13.6,
            "specific_heat (@20°C J/g mol)" : 0.322,
            "fusion_heat (kJ/mol)" : 36.8,
            "evaporation_heat (kJ/mol)" : 328,
            "thermal_conductivity (@25°C W/m K) " : 60.2,
            "pauling_negativity" : 2.01,
            "first_ionizing kJ/mol" : 760.0,
            "oxidation_states" : 4,
            "electronic_configuration" : "[Ar]3d¹4s²4p²",
            "lattice_structure" : "DIA",
            "lattice_constant ang" : 5.660
        },
        "Arsenic": {
            "symbol" : "As",
            "atomic_number" : 33,
            "atomic_weight" : 74.92159,
            "density g/cm" : "5.73 (grey arsenic)",
            "melting_point K" : 1090,
            "boiling_point K" : 876,
            "atomic_radius pm" : 139,
            "covalent_radius pm" : 120,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 13.1,
            "specific_heat (@20°C J/g mol)" : 0.328,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 32.4,
            "thermal_conductivity (@25°C W/m K) " : "(50.2)",
            "pauling_negativity" : 2.18,
            "first_ionizing kJ/mol" : 946.2,
            "oxidation_states" : "5, 3, -2",
            "electronic_configuration" : "[Ar]3d¹4s²4p³",
            "lattice_structure" : "RHL",
            "lattice_constant ang" : 4.130
        },
        "Selenium": {
            "symbol" : "Se",
            "atomic_number" : 34,
            "atomic_weight" : 78.96,
            "density g/cm" : 4.79,
            "melting_point K" : 490,
            "boiling_point K" : 958.1,
            "atomic_radius pm" : 140,
            "covalent_radius pm" : 116,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 16.5,
            "specific_heat (@20°C J/g mol)" : "0.321 (Se-Se)",
            "fusion_heat (kJ/mol)" : 5.23,
            "evaporation_heat (kJ/mol)" : 59.7,
            "thermal_conductivity (@25°C W/m K) " : 0.52,
            "pauling_negativity" : 2.55,
            "first_ionizing kJ/mol" : 940.4,
            "oxidation_states" : "6, 4, -2",
            "electronic_configuration" : "[Ar]3d¹4s²4p",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 4.360
        },
        "Bromine": {
            "symbol" : "Br",
            "atomic_number" : 35,
            "atomic_weight" : 79.904,
            "density g/cm" : 3.12,
            "melting_point K" : 265.9,
            "boiling_point K" : 331.9,
            "atomic_radius pm" : "-",
            "covalent_radius pm" : 114,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 23.5,
            "specific_heat (@20°C J/g mol)" : "0.473 (Br-Br)",
            "fusion_heat (kJ/mol)" : "10.57 (Br-Br)",
            "evaporation_heat (kJ/mol)" : "29.56 (Br-Br)",
            "thermal_conductivity (@25°C W/m K) " : 0.005,
            "pauling_negativity" : 2.96,
            "first_ionizing kJ/mol" : 1142.0,
            "oxidation_states" : "7, 5, 3, 1, -1",
            "electronic_configuration" : "[Ar]3d¹4s²4p",
            "lattice_structure" : "ORC",
            "lattice_constant ang" : 6.670
        },
        "Krypton": {
            "symbol" : "Kr",
            "atomic_number" : 36,
            "atomic_weight" : 83.8,
            "density g/cm" : "2.155 (@ -153°C)",
            "melting_point K" : 116.6,
            "boiling_point K" : 120.85,
            "atomic_radius pm" : "-",
            "covalent_radius pm" : 112,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 32.2,
            "specific_heat (@20°C J/g mol)" : 0.247,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 9.05,
            "thermal_conductivity (@25°C W/m K) " : 0.0095,
            "pauling_negativity" : 0.0,
            "first_ionizing kJ/mol" : 1350.0,
            "oxidation_states" : 2,
            "electronic_configuration" : "[Ar]3d¹4s²4p",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 5.720
        },
        "Rubidium": {
            "symbol" : "Rb",
            "atomic_number" : 37,
            "atomic_weight" : 85.4678,
            "density g/cm" : 1.532,
            "melting_point K" : 312.2,
            "boiling_point K" : 961,
            "atomic_radius pm" : 248,
            "covalent_radius pm" : 216,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 55.9,
            "specific_heat (@20°C J/g mol)" : 0.360,
            "fusion_heat (kJ/mol)" : 2.20,
            "evaporation_heat (kJ/mol)" : 75.8,
            "thermal_conductivity (@25°C W/m K) " : 58.2,
            "pauling_negativity" : 0.82,
            "first_ionizing kJ/mol" : 402.8,
            "oxidation_states" : 1,
            "electronic_configuration" : "[Kr]5s¹",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : 5.590
        },
        "Strontium": {
            "symbol" : "Sr",
            "atomic_number" : 38,
            "atomic_weight" : 87.62,
            "density g/cm" : 2.54,
            "melting_point K" : 1042,
            "boiling_point K" : 1657,
            "atomic_radius pm" : 215,
            "covalent_radius pm" : 191,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 33.7,
            "specific_heat (@20°C J/g mol)" : 0.301,
            "fusion_heat (kJ/mol)" : 9.20,
            "evaporation_heat (kJ/mol)" : 144,
            "thermal_conductivity (@25°C W/m K) " : "(35.4)",
            "pauling_negativity" : 0.95,
            "first_ionizing kJ/mol" : 549.0,
            "oxidation_states" : 2,
            "electronic_configuration" : "[Kr]5s²",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 6.080
        },
        "Yttrium": {
            "symbol" : "Y",
            "atomic_number" : 39,
            "atomic_weight" : 88.90585,
            "density g/cm" : 4.47,
            "melting_point K" : 1795,
            "boiling_point K" : 3611,
            "atomic_radius pm" : 178,
            "covalent_radius pm" : 162,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 19.8,
            "specific_heat (@20°C J/g mol)" : 0.284,
            "fusion_heat (kJ/mol)" : 11.5,
            "evaporation_heat (kJ/mol)" : 367,
            "thermal_conductivity (@25°C W/m K) " : "(17.2)",
            "pauling_negativity" : 1.22,
            "first_ionizing kJ/mol" : 615.4,
            "oxidation_states" : 3,
            "electronic_configuration" : "[Kr]4d¹5s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.650
        },
        "Zirconium": {
            "symbol" : "Zr",
            "atomic_number" : 40,
            "atomic_weight" : 91.224,
            "density g/cm" : 6.506,
            "melting_point K" : 2125,
            "boiling_point K" : 4650,
            "atomic_radius pm" : 160,
            "covalent_radius pm" : 145,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 14.1,
            "specific_heat (@20°C J/g mol)" : 0.281,
            "fusion_heat (kJ/mol)" : 19.2,
            "evaporation_heat (kJ/mol)" : 567,
            "thermal_conductivity (@25°C W/m K) " : 22.7,
            "pauling_negativity" : 1.33,
            "first_ionizing kJ/mol" : 659.7,
            "oxidation_states" : 4,
            "electronic_configuration" : "[Kr]4d²5s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.230
        },
        "Niobium": {
            "symbol" : "Nb",
            "atomic_number" : 41,
            "atomic_weight" : 92.90638,
            "density g/cm" : 8.57,
            "melting_point K" : 2741,
            "boiling_point K" : 5015,
            "atomic_radius pm" : 146,
            "covalent_radius pm" : 134,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 10.8,
            "specific_heat (@20°C J/g mol)" : 0.268,
            "fusion_heat (kJ/mol)" : 26.8,
            "evaporation_heat (kJ/mol)" : 680,
            "thermal_conductivity (@25°C W/m K) " : 53.7,
            "pauling_negativity" : 1.6,
            "first_ionizing kJ/mol" : 663.6,
            "oxidation_states" : "5, 3",
            "electronic_configuration" : "[Kr]4d5s¹",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : 3.300
        },
        "Molybdenum": {
            "symbol" : "Mo",
            "atomic_number" : 42,
            "atomic_weight" : 95.94,
            "density g/cm" : 10.22,
            "melting_point K" : 2890,
            "boiling_point K" : 4885,
            "atomic_radius pm" : 139,
            "covalent_radius pm" : 130,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 9.4,
            "specific_heat (@20°C J/g mol)" : 0.251,
            "fusion_heat (kJ/mol)" : 28,
            "evaporation_heat (kJ/mol)" : "~590",
            "thermal_conductivity (@25°C W/m K) " : "(138)",
            "pauling_negativity" : 2.16,
            "first_ionizing kJ/mol" : 684.8,
            "oxidation_states" : "6, 5, 4, 3, 2, 0",
            "electronic_configuration" : "[Kr]4d5s¹",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : 3.150
        },
        "Technetium": {
            "symbol" : "Tc",
            "atomic_number" : 43,
            "atomic_weight" : 97.9072,
            "density g/cm" : 11.5,
            "melting_point K" : 2445,
            "boiling_point K" : 5150,
            "atomic_radius pm" : 136,
            "covalent_radius pm" : 127,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 8.5,
            "specific_heat (@20°C J/g mol)" : 0.243,
            "fusion_heat (kJ/mol)" : 23.8,
            "evaporation_heat (kJ/mol)" : 585,
            "thermal_conductivity (@25°C W/m K) " : 50.6,
            "pauling_negativity" : 1.9,
            "first_ionizing kJ/mol" : 702.2,
            "oxidation_states" : 7,
            "electronic_configuration" : "[Kr]4d5s¹",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 2.740
        },
        "Ruthenium": {
            "symbol" : "Ru",
            "atomic_number" : 44,
            "atomic_weight" : 101.07,
            "density g/cm" : 12.41,
            "melting_point K" : 2583,
            "boiling_point K" : 4173,
            "atomic_radius pm" : 134,
            "covalent_radius pm" : 125,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 8.3,
            "specific_heat (@20°C J/g mol)" : 0.238,
            "fusion_heat (kJ/mol)" : "(25.5)",
            "evaporation_heat (kJ/mol)" : "-",
            "thermal_conductivity (@25°C W/m K) " : 117.0,
            "pauling_negativity" : 2.2,
            "first_ionizing kJ/mol" : 710.3,
            "oxidation_states" : "8, 6, 4, 3, 2, 0, -2",
            "electronic_configuration" : "[Kr]4d5s¹",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 2.700
        },
        "Rhodium": {
            "symbol" : "Rh",
            "atomic_number" : 45,
            "atomic_weight" : 102.9055,
            "density g/cm" : 12.41,
            "melting_point K" : 2239,
            "boiling_point K" : 4000,
            "atomic_radius pm" : 134,
            "covalent_radius pm" : 125,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 8.3,
            "specific_heat (@20°C J/g mol)" : 0.244,
            "fusion_heat (kJ/mol)" : 21.8,
            "evaporation_heat (kJ/mol)" : 494,
            "thermal_conductivity (@25°C W/m K) " : 150,
            "pauling_negativity" : 2.28,
            "first_ionizing kJ/mol" : 719.5,
            "oxidation_states" : "5, 4, 3, 2, 1, 0",
            "electronic_configuration" : "[Kr]4d5s¹",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 3.800
        },
        "Palladium": {
            "symbol" : "Pd",
            "atomic_number" : 46,
            "atomic_weight" : 106.42,
            "density g/cm" : 12.02,
            "melting_point K" : 1825,
            "boiling_point K" : 3413,
            "atomic_radius pm" : 137,
            "covalent_radius pm" : 128,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 8.9,
            "specific_heat (@20°C J/g mol)" : 0.244,
            "fusion_heat (kJ/mol)" : 17.24,
            "evaporation_heat (kJ/mol)" : 372.4,
            "thermal_conductivity (@25°C W/m K) " : 71.8,
            "pauling_negativity" : 2.20,
            "first_ionizing kJ/mol" : 803.5,
            "oxidation_states" : "4, 2, 0",
            "electronic_configuration" : "[Kr]4d5s",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 3.890
        },
        "Silver": {
            "symbol" : "Ag",
            "atomic_number" : 47,
            "atomic_weight" : 107.8682,
            "density g/cm" : 10.5,
            "melting_point K" : 1235.1,
            "boiling_point K" : 2485,
            "atomic_radius pm" : 144,
            "covalent_radius pm" : 134,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 10.3,
            "specific_heat (@20°C J/g mol)" : 0.237,
            "fusion_heat (kJ/mol)" : 11.95,
            "evaporation_heat (kJ/mol)" : 254.1,
            "thermal_conductivity (@25°C W/m K) " : 429,
            "pauling_negativity" : 1.93,
            "first_ionizing kJ/mol" : 730.5,
            "oxidation_states" : "2, 1",
            "electronic_configuration" : "[Kr]4d5s¹",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 4.090
        },
        "Cadmium": {
            "symbol" : "Cd",
            "atomic_number" : 48,
            "atomic_weight" : 112.411,
            "density g/cm" : 8.65,
            "melting_point K" : 594.1,
            "boiling_point K" : 1038,
            "atomic_radius pm" : 154,
            "covalent_radius pm" : 148,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 13.1,
            "specific_heat (@20°C J/g mol)" : 0.232,
            "fusion_heat (kJ/mol)" : 6.11,
            "evaporation_heat (kJ/mol)" : 59.1,
            "thermal_conductivity (@25°C W/m K) " : 96.9,
            "pauling_negativity" : 1.69,
            "first_ionizing kJ/mol" : 867.2,
            "oxidation_states" : 2,
            "electronic_configuration" : "[Kr]4d5s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 2.980
        },
        "Indium": {
            "symbol" : "In",
            "atomic_number" : 49,
            "atomic_weight" : 114.818,
            "density g/cm" : 7.31,
            "melting_point K" : 429.32,
            "boiling_point K" : 2353,
            "atomic_radius pm" : 166,
            "covalent_radius pm" : 144,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 15.7,
            "specific_heat (@20°C J/g mol)" : 0.234,
            "fusion_heat (kJ/mol)" : 3.24,
            "evaporation_heat (kJ/mol)" : 225.1,
            "thermal_conductivity (@25°C W/m K) " : 81.8,
            "pauling_negativity" : 1.78,
            "first_ionizing kJ/mol" : 558.0,
            "oxidation_states" : 3,
            "electronic_configuration" : "[Kr]4d5s²5p¹",
            "lattice_structure" : "TET",
            "lattice_constant ang" : 4.590
        },
        "Tin": {
            "symbol" : "Sn",
            "atomic_number" : 50,
            "atomic_weight" : 118.71,
            "density g/cm" : 7.31,
            "melting_point K" : 505.1,
            "boiling_point K" : 2543,
            "atomic_radius pm" : 162,
            "covalent_radius pm" : 141,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 16.3,
            "specific_heat (@20°C J/g mol)" : 0.222,
            "fusion_heat (kJ/mol)" : 7.07,
            "evaporation_heat (kJ/mol)" : 296,
            "thermal_conductivity (@25°C W/m K) " : 66.8,
            "pauling_negativity" : 1.96,
            "first_ionizing kJ/mol" : 708.2,
            "oxidation_states" : "4, 2",
            "electronic_configuration" : "[Kr]4d5s²5p²",
            "lattice_structure" : "TET",
            "lattice_constant ang" : 5.820
        },
        "Antimony": {
            "symbol" : "Sb",
            "atomic_number" : 51,
            "atomic_weight" : 121.760,
            "density g/cm" : 6.691,
            "melting_point K" : 903.9,
            "boiling_point K" : 1908,
            "atomic_radius pm" : 159,
            "covalent_radius pm" : 140,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 18.4,
            "specific_heat (@20°C J/g mol)" : 0.205,
            "fusion_heat (kJ/mol)" : 20.08,
            "evaporation_heat (kJ/mol)" : 195.2,
            "thermal_conductivity (@25°C W/m K) " : 24.43,
            "pauling_negativity" : 2.05,
            "first_ionizing kJ/mol" : 833.3,
            "oxidation_states" : "5, 3, -2",
            "electronic_configuration" : "[Kr]4d5s²5p³",
            "lattice_structure" : "RHL",
            "lattice_constant ang" : 4.510
        },
        "Tellurium": {
            "symbol" : "Te",
            "atomic_number" : 52,
            "atomic_weight" : 127.6,
            "density g/cm" : 6.24,
            "melting_point K" : 722.7,
            "boiling_point K" : 1263,
            "atomic_radius pm" : 160,
            "covalent_radius pm" : 136,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 20.5,
            "specific_heat (@20°C J/g mol)" : 0.201,
            "fusion_heat (kJ/mol)" : 17.91,
            "evaporation_heat (kJ/mol)" : 49.8,
            "thermal_conductivity (@25°C W/m K) " : 14.3,
            "pauling_negativity" : 2.1,
            "first_ionizing kJ/mol" : 869.0,
            "oxidation_states" : "6, 4, 2",
            "electronic_configuration" : "[Kr]4d5s²5p",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 4.450
        },
        "Iodine": {
            "symbol" : "I",
            "atomic_number" : 53,
            "atomic_weight" : 126.90447,
            "density g/cm" : 4.93,
            "melting_point K" : 386.7,
            "boiling_point K" : 457.5,
            "atomic_radius pm" : "-",
            "covalent_radius pm" : 133,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 25.7,
            "specific_heat (@20°C J/g mol)" : "0.427 (I-I)",
            "fusion_heat (kJ/mol)" : "15.52 (I-I)",
            "evaporation_heat (kJ/mol)" : "41.95 (I-I)",
            "thermal_conductivity (@25°C W/m K) " : "(0.45)",
            "pauling_negativity" : 2.66,
            "first_ionizing kJ/mol" : 1008.3,
            "oxidation_states" : "7, 5, 1, -1",
            "electronic_configuration" : "[Kr]4d5s²5p",
            "lattice_structure" : "ORC",
            "lattice_constant ang" : 7.720
        },
        "Xenon": {
            "symbol" : "Xe",
            "atomic_number" : 54,
            "atomic_weight" : 131.29,
            "density g/cm" : "3.52 (@ -109°C)",
            "melting_point K" : 161.3,
            "boiling_point K" : 166.1,
            "atomic_radius pm" : "-",
            "covalent_radius pm" : 131,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 42.9,
            "specific_heat (@20°C J/g mol)" : 0.158,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 12.65,
            "thermal_conductivity (@25°C W/m K) " : 0.0057,
            "pauling_negativity" : 0.0,
            "first_ionizing kJ/mol" : 1170.0,
            "oxidation_states" : 7,
            "electronic_configuration" : "[Kr]4d5s²5p",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 6.200
        },
        "Cesium": {
            "symbol" : "Cs",
            "atomic_number" : 55,
            "atomic_weight" : 132.90543,
            "density g/cm" : 1.873,
            "melting_point K" : 301.6,
            "boiling_point K" : 951.6,
            "atomic_radius pm" : 267,
            "covalent_radius pm" : 235,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 70.0,
            "specific_heat (@20°C J/g mol)" : 0.241,
            "fusion_heat (kJ/mol)" : 2.09,
            "evaporation_heat (kJ/mol)" : 68.3,
            "thermal_conductivity (@25°C W/m K) " : 35.9,
            "pauling_negativity" : 0.79,
            "first_ionizing kJ/mol" : 375.5,
            "oxidation_states" : 1,
            "electronic_configuration" : "[Xe]6s¹",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : 6.050
        },
        "Barium": {
            "symbol" : "Ba",
            "atomic_number" : 56,
            "atomic_weight" : 137.327,
            "density g/cm" : 3.5,
            "melting_point K" : 1002,
            "boiling_point K" : 1910,
            "atomic_radius pm" : 222,
            "covalent_radius pm" : 198,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 39.0,
            "specific_heat (@20°C J/g mol)" : 0.192,
            "fusion_heat (kJ/mol)" : 7.66,
            "evaporation_heat (kJ/mol)" : 142.0,
            "thermal_conductivity (@25°C W/m K) " : "(18.4)",
            "pauling_negativity" : 0.89,
            "first_ionizing kJ/mol" : 502.5,
            "oxidation_states" : 2,
            "electronic_configuration" : "[Xe]6s²",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : 5.020
        },
        "Lanthanum": {
            "symbol" : "La",
            "atomic_number" : 57,
            "atomic_weight" : 138.9055,
            "density g/cm" : 6.15,
            "melting_point K" : 1194,
            "boiling_point K" : 3730,
            "atomic_radius pm" : 187,
            "covalent_radius pm" : 169,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 22.5,
            "specific_heat (@20°C J/g mol)" : 0.197,
            "fusion_heat (kJ/mol)" : 8.5,
            "evaporation_heat (kJ/mol)" : 402,
            "thermal_conductivity (@25°C W/m K) " : 13.4,
            "pauling_negativity" : 1.10,
            "first_ionizing kJ/mol" : 541.1,
            "oxidation_states" : 3,
            "electronic_configuration" : "[Xe]6d¹6s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.750
        },
        "Cerium": {
            "symbol" : "Ce",
            "atomic_number" : 58,
            "atomic_weight" : 140.115,
            "density g/cm" : 6.757,
            "melting_point K" : 1072,
            "boiling_point K" : 3699,
            "atomic_radius pm" : 181,
            "covalent_radius pm" : 165,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 21.0,
            "specific_heat (@20°C J/g mol)" : 0.205,
            "fusion_heat (kJ/mol)" : 5.2,
            "evaporation_heat (kJ/mol)" : 398,
            "thermal_conductivity (@25°C W/m K) " : 11.3,
            "pauling_negativity" : 1.12,
            "first_ionizing kJ/mol" : 540.1,
            "oxidation_states" : "4, 3",
            "electronic_configuration" : "[Xe]4f¹5d¹6s²",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 5.160
        },
        "Praseodymium": {
            "symbol" : "Pr",
            "atomic_number" : 59,
            "atomic_weight" : 140.90765,
            "density g/cm" : 6.773,
            "melting_point K" : 1204,
            "boiling_point K" : 3785,
            "atomic_radius pm" : 182,
            "covalent_radius pm" : 165,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 20.8,
            "specific_heat (@20°C J/g mol)" : 0.192,
            "fusion_heat (kJ/mol)" : 11.3,
            "evaporation_heat (kJ/mol)" : 331,
            "thermal_conductivity (@25°C W/m K) " : 12.5,
            "pauling_negativity" : 1.13,
            "first_ionizing kJ/mol" : 526.6,
            "oxidation_states" : "4, 3",
            "electronic_configuration" : "[Xe]4f³5d6s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.670
        },
        "Neodymium": {
            "symbol" : "Nd",
            "atomic_number" : 60,
            "atomic_weight" : 144.24,
            "density g/cm" : 7.007,
            "melting_point K" : 1294,
            "boiling_point K" : 3341,
            "atomic_radius pm" : 182,
            "covalent_radius pm" : 184,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 20.6,
            "specific_heat (@20°C J/g mol)" : 0.205,
            "fusion_heat (kJ/mol)" : 7.1,
            "evaporation_heat (kJ/mol)" : 289,
            "thermal_conductivity (@25°C W/m K) " : "(16.5)",
            "pauling_negativity" : 1.14,
            "first_ionizing kJ/mol" : 531.5,
            "oxidation_states" : 3,
            "electronic_configuration" : "[Xe]4f5d6s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.660
        },
        "Promethium": {
            "symbol" : "Pm",
            "atomic_number" : 61,
            "atomic_weight" : 144.9127,
            "density g/cm" : 7.2,
            "melting_point K" : 1441,
            "boiling_point K" : 3000,
            "atomic_radius pm" : "-",
            "covalent_radius pm" : 163,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "-",
            "specific_heat (@20°C J/g mol)" : 0.185,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : "-",
            "thermal_conductivity (@25°C W/m K) " : 17.9,
            "pauling_negativity" : 0.0,
            "first_ionizing kJ/mol" : 536,
            "oxidation_states" : 3,
            "electronic_configuration" : "[Xe]4f5d6s²",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Samarium": {
            "symbol" : "Sm",
            "atomic_number" : 62,
            "atomic_weight" : 150.36,
            "density g/cm" : 7.520,
            "melting_point K" : 1350,
            "boiling_point K" : 2064,
            "atomic_radius pm" : 181,
            "covalent_radius pm" : 162,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 19.9,
            "specific_heat (@20°C J/g mol)" : 0.180,
            "fusion_heat (kJ/mol)" : 8.9,
            "evaporation_heat (kJ/mol)" : 165,
            "thermal_conductivity (@25°C W/m K) " : "(13.3)",
            "pauling_negativity" : 1.17,
            "first_ionizing kJ/mol" : 540.1,
            "oxidation_states" : "3, 2",
            "electronic_configuration" : "[Xe]4f5d6s²",
            "lattice_structure" : "RHL",
            "lattice_constant ang" : 9.000
        },
        "Europium": {
            "symbol" : "Eu",
            "atomic_number" : 63,
            "atomic_weight" : 151.965,
            "density g/cm" : 5.243,
            "melting_point K" : 1095,
            "boiling_point K" : 1870,
            "atomic_radius pm" : 199,
            "covalent_radius pm" : 185,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 28.9,
            "specific_heat (@20°C J/g mol)" : 0.176,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 176,
            "thermal_conductivity (@25°C W/m K) " : 13.9,
            "pauling_negativity" : 0.0,
            "first_ionizing kJ/mol" : 546.9,
            "oxidation_states" : "3, 2",
            "electronic_configuration" : "[Xe]4f5d6s²",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : 4.610
        },
        "Gadolinium": {
            "symbol" : "Gd",
            "atomic_number" : 64,
            "atomic_weight" : 157.25,
            "density g/cm" : 7.900,
            "melting_point K" : 1586,
            "boiling_point K" : 3539,
            "atomic_radius pm" : 179,
            "covalent_radius pm" : 161,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 19.9,
            "specific_heat (@20°C J/g mol)" : 0.230,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 398,
            "thermal_conductivity (@25°C W/m K) " : "(10.5)",
            "pauling_negativity" : 1.20,
            "first_ionizing kJ/mol" : 594.2,
            "oxidation_states" : 3,
            "electronic_configuration" : "[Xe]4f5d¹6s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.640
        },
        "Terbium": {
            "symbol" : "Tb",
            "atomic_number" : 65,
            "atomic_weight" : 158.92534,
            "density g/cm" : 8.229,
            "melting_point K" : 1629,
            "boiling_point K" : 3296,
            "atomic_radius pm" : 180,
            "covalent_radius pm" : 159,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 19.2,
            "specific_heat (@20°C J/g mol)" : 0.183,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 389,
            "thermal_conductivity (@25°C W/m K) " : 11.1,
            "pauling_negativity" : 1.2,
            "first_ionizing kJ/mol" : 569,
            "oxidation_states" : "4, 3",
            "electronic_configuration" : "[Xe]4f5d6s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.600
        },
        "Dysprosium": {
            "symbol" : "Dy",
            "atomic_number" : 66,
            "atomic_weight" : 162.50,
            "density g/cm" : 8.55,
            "melting_point K" : 1685,
            "boiling_point K" : 2835,
            "atomic_radius pm" : 180,
            "covalent_radius pm" : 159,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 19.0,
            "specific_heat (@20°C J/g mol)" : 0.173,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 291,
            "thermal_conductivity (@25°C W/m K) " : 10.7,
            "pauling_negativity" : "-",
            "first_ionizing kJ/mol" : 567,
            "oxidation_states" : 3,
            "electronic_configuration" : "[Xe]4f5d6s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.590
        },
        "Holmium": {
            "symbol" : "Ho",
            "atomic_number" : 67,
            "atomic_weight" : 164.93032,
            "density g/cm" : 8.795,
            "melting_point K" : 1747,
            "boiling_point K" : 2968,
            "atomic_radius pm" : 179,
            "covalent_radius pm" : 158,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 18.7,
            "specific_heat (@20°C J/g mol)" : 0.164,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 301,
            "thermal_conductivity (@25°C W/m K) " : "(16.2)",
            "pauling_negativity" : 1.23,
            "first_ionizing kJ/mol" : 574,
            "oxidation_states" : 3,
            "electronic_configuration" : "[Xe]4f¹¹5d6s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.580
        },
        "Erbium": {
            "symbol" : "Er",
            "atomic_number" : 68,
            "atomic_weight" : 167.26,
            "density g/cm" : 9.06,
            "melting_point K" : 1802,
            "boiling_point K" : 3136,
            "atomic_radius pm" : 178,
            "covalent_radius pm" : 157,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 18.4,
            "specific_heat (@20°C J/g mol)" : 0.168,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 317,
            "thermal_conductivity (@25°C W/m K) " : "(14.5)",
            "pauling_negativity" : 1.24,
            "first_ionizing kJ/mol" : 581,
            "oxidation_states" : 3,
            "electronic_configuration" : "[Xe]4f¹²5d6s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.560
        },
        "Thulium": {
            "symbol" : "Tm",
            "atomic_number" : 69,
            "atomic_weight" : 168.93421,
            "density g/cm" : 9.321,
            "melting_point K" : 1818,
            "boiling_point K" : 2220,
            "atomic_radius pm" : 177,
            "covalent_radius pm" : 156,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 18.1,
            "specific_heat (@20°C J/g mol)" : 0.160,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 232,
            "thermal_conductivity (@25°C W/m K) " : "(16.9)",
            "pauling_negativity" : 1.25,
            "first_ionizing kJ/mol" : 589,
            "oxidation_states" : "3, 2",
            "electronic_configuration" : "[Xe]4f¹³5d6s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.540
        },
        "Ytterbium": {
            "symbol" : "Yb",
            "atomic_number" : 70,
            "atomic_weight" : 173.04,
            "density g/cm" : 6.9654,
            "melting_point K" : 1097,
            "boiling_point K" : 1466,
            "atomic_radius pm" : 194,
            "covalent_radius pm" : "-",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 24.8,
            "specific_heat (@20°C J/g mol)" : 0.145,
            "fusion_heat (kJ/mol)" : 3.35,
            "evaporation_heat (kJ/mol)" : 159,
            "thermal_conductivity (@25°C W/m K) " : "(34.9)",
            "pauling_negativity" : 1.1,
            "first_ionizing kJ/mol" : 603,
            "oxidation_states" : "3, 2",
            "electronic_configuration" : "[Xe]4f¹5d¹6s²",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 5.490
        },
        "Lutetium": {
            "symbol" : "Lu",
            "atomic_number" : 71,
            "atomic_weight" : 174.967,
            "density g/cm" : 9.8404,
            "melting_point K" : 1936,
            "boiling_point K" : 3668,
            "atomic_radius pm" : 175,
            "covalent_radius pm" : 156,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 17.8,
            "specific_heat (@20°C J/g mol)" : 0.155,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 414,
            "thermal_conductivity (@25°C W/m K) " : "(16.4)",
            "pauling_negativity" : 1.27,
            "first_ionizing kJ/mol" : 513,
            "oxidation_states" : 3,
            "electronic_configuration" : "[Xe]4f¹5d¹6s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.510
        },
        "Hafnium": {
            "symbol" : "Hf",
            "atomic_number" : 72,
            "atomic_weight" : 178.49,
            "density g/cm" : 13.31,
            "melting_point K" : 2503,
            "boiling_point K" : 5470,
            "atomic_radius pm" : 167,
            "covalent_radius pm" : 144,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 13.6,
            "specific_heat (@20°C J/g mol)" : 0.146,
            "fusion_heat (kJ/mol)" : "(25.1)",
            "evaporation_heat (kJ/mol)" : 575,
            "thermal_conductivity (@25°C W/m K) " : 23.0,
            "pauling_negativity" : 1.3,
            "first_ionizing kJ/mol" : 575.2,
            "oxidation_states" : 4,
            "electronic_configuration" : "[Xe]4f¹5d²6s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.200
        },
        "Tantalum": {
            "symbol" : "Ta",
            "atomic_number" : 73,
            "atomic_weight" : 180.9479,
            "density g/cm" : 16.654,
            "melting_point K" : 3269,
            "boiling_point K" : 5698,
            "atomic_radius pm" : 149,
            "covalent_radius pm" : 134,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 10.9,
            "specific_heat (@20°C J/g mol)" : 0.140,
            "fusion_heat (kJ/mol)" : 24.7,
            "evaporation_heat (kJ/mol)" : 758,
            "thermal_conductivity (@25°C W/m K) " : 57.5,
            "pauling_negativity" : 1.5,
            "first_ionizing kJ/mol" : 760.1,
            "oxidation_states" : 5,
            "electronic_configuration" : "[Xe]4f¹5d³6s²",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : 3.310
        },
        "Tungsten": {
            "symbol" : "W",
            "atomic_number" : 74,
            "atomic_weight" : 183.84,
            "density g/cm" : 19.3,
            "melting_point K" : 3680,
            "boiling_point K" : 5930,
            "atomic_radius pm" : 141,
            "covalent_radius pm" : 130,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 9.53,
            "specific_heat (@20°C J/g mol)" : 0.133,
            "fusion_heat (kJ/mol)" : "(35)",
            "evaporation_heat (kJ/mol)" : 824,
            "thermal_conductivity (@25°C W/m K) " : 173,
            "pauling_negativity" : 1.7,
            "first_ionizing kJ/mol" : 769.7,
            "oxidation_states" : "6, 5, 4, 3, 2, 0",
            "electronic_configuration" : "[Xe]4f¹5d6s²",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : 3.160
        },
        "Rhenium": {
            "symbol" : "Re",
            "atomic_number" : 75,
            "atomic_weight" : 186.207,
            "density g/cm" : 21.02,
            "melting_point K" : 3453,
            "boiling_point K" : 5900,
            "atomic_radius pm" : 137,
            "covalent_radius pm" : 128,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 8.85,
            "specific_heat (@20°C J/g mol)" : 0.138,
            "fusion_heat (kJ/mol)" : 34,
            "evaporation_heat (kJ/mol)" : 704,
            "thermal_conductivity (@25°C W/m K) " : 48.0,
            "pauling_negativity" : 1.9,
            "first_ionizing kJ/mol" : 759.1,
            "oxidation_states" : "5, 4, 3, 2, -1",
            "electronic_configuration" : "[Xe]4f¹5d6s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 2.760
        },
        "Osmium": {
            "symbol" : "Os",
            "atomic_number" : 76,
            "atomic_weight" : 190.23,
            "density g/cm" : 22.57,
            "melting_point K" : 3327,
            "boiling_point K" : 5300,
            "atomic_radius pm" : 135,
            "covalent_radius pm" : 126,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 8.43,
            "specific_heat (@20°C J/g mol)" : 0.131,
            "fusion_heat (kJ/mol)" : 31.7,
            "evaporation_heat (kJ/mol)" : 738,
            "thermal_conductivity (@25°C W/m K) " : "(87.6)",
            "pauling_negativity" : 2.2,
            "first_ionizing kJ/mol" : 819.8,
            "oxidation_states" : "8, 6, 4, 3, 2, 0, -2",
            "electronic_configuration" : "[Xe]4f¹5d6s²",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 2.740
        },
        "Iridium": {
            "symbol" : "Ir",
            "atomic_number" : 77,
            "atomic_weight" : 192.22,
            "density g/cm" : 22.42,
            "melting_point K" : 2683,
            "boiling_point K" : 4403,
            "atomic_radius pm" : 136,
            "covalent_radius pm" : 127,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 8.54,
            "specific_heat (@20°C J/g mol)" : 0.133,
            "fusion_heat (kJ/mol)" : 27.61,
            "evaporation_heat (kJ/mol)" : 604,
            "thermal_conductivity (@25°C W/m K) " : 147,
            "pauling_negativity" : 2.20,
            "first_ionizing kJ/mol" : 868.1,
            "oxidation_states" : "6, 4, 3, 2, 1, 0, -1",
            "electronic_configuration" : "[Xe]4f¹5d6s²",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 3.840
        },
        "Platinum": {
            "symbol" : "Pt",
            "atomic_number" : 78,
            "atomic_weight" : 195.08,
            "density g/cm" : 21.45,
            "melting_point K" : 2045,
            "boiling_point K" : 4100,
            "atomic_radius pm" : 139,
            "covalent_radius pm" : 130,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 9.10,
            "specific_heat (@20°C J/g mol)" : 0.133,
            "fusion_heat (kJ/mol)" : 21.76,
            "evaporation_heat (kJ/mol)" : "~470",
            "thermal_conductivity (@25°C W/m K) " : 71.6,
            "pauling_negativity" : 2.28,
            "first_ionizing kJ/mol" : 868.1,
            "oxidation_states" : "4, 2, 0",
            "electronic_configuration" : "[Xe]4f¹5d6s²",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 3.920
        },
        "Gold": {
            "symbol" : "Au",
            "atomic_number" : 79,
            "atomic_weight" : 196.96654,
            "density g/cm" : 19.3,
            "melting_point K" : 1337.58,
            "boiling_point K" : 3080,
            "atomic_radius pm" : 146,
            "covalent_radius pm" : 134,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 10.2,
            "specific_heat (@20°C J/g mol)" : 0.129,
            "fusion_heat (kJ/mol)" : 12.68,
            "evaporation_heat (kJ/mol)" : "~340",
            "thermal_conductivity (@25°C W/m K) " : 318,
            "pauling_negativity" : 2.54,
            "first_ionizing kJ/mol" : 889.3,
            "oxidation_states" : "3, 1",
            "electronic_configuration" : "[Xe]4f¹5d¹6s²",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 4.080
        },
        "Mercury": {
            "symbol" : "Hg",
            "atomic_number" : 80,
            "atomic_weight" : 200.59,
            "density g/cm" : "13.546 (@ +20°C)",
            "melting_point K" : 234.28,
            "boiling_point K" : 629.73,
            "atomic_radius pm" : 157,
            "covalent_radius pm" : 149,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 14.8,
            "specific_heat (@20°C J/g mol)" : 0.138,
            "fusion_heat (kJ/mol)" : 2.295,
            "evaporation_heat (kJ/mol)" : 58.5,
            "thermal_conductivity (@25°C W/m K) " : 8.3,
            "pauling_negativity" : 2.00,
            "first_ionizing kJ/mol" : 1006.0,
            "oxidation_states" : "2, 1",
            "electronic_configuration" : "[Xe]4f¹5d¹6s²",
            "lattice_structure" : "RHL",
            "lattice_constant ang" : 2.990
        },
        "Thallium": {
            "symbol" : "Tl",
            "atomic_number" : 81,
            "atomic_weight" : 204.3833,
            "density g/cm" : 11.85,
            "melting_point K" : 576.6,
            "boiling_point K" : 1730,
            "atomic_radius pm" : 171,
            "covalent_radius pm" : 148,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 17.2,
            "specific_heat (@20°C J/g mol)" : 0.128,
            "fusion_heat (kJ/mol)" : 4.31,
            "evaporation_heat (kJ/mol)" : 162.4,
            "thermal_conductivity (@25°C W/m K) " : 46.1,
            "pauling_negativity" : 1.62,
            "first_ionizing kJ/mol" : 588.9,
            "oxidation_states" : "3, 1",
            "electronic_configuration" : "[Xe]4f¹5d¹6s²6p¹",
            "lattice_structure" : "HEX",
            "lattice_constant ang" : 3.460
        },
        "Lead": {
            "symbol" : "Pb",
            "atomic_number" : 82,
            "atomic_weight" : 207.2,
            "density g/cm" : 11.35,
            "melting_point K" : 600.65,
            "boiling_point K" : 2013,
            "atomic_radius pm" : 175,
            "covalent_radius pm" : 147,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 18.3,
            "specific_heat (@20°C J/g mol)" : 0.159,
            "fusion_heat (kJ/mol)" : 4.77,
            "evaporation_heat (kJ/mol)" : 177.8,
            "thermal_conductivity (@25°C W/m K) " : 35.3,
            "pauling_negativity" : 1.8,
            "first_ionizing kJ/mol" : 715.2,
            "oxidation_states" : "4, 2",
            "electronic_configuration" : "[Xe]4f¹5d¹6s²6p²",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 4.950
        },
        "Bismuth": {
            "symbol" : "Bi",
            "atomic_number" : 83,
            "atomic_weight" : 208.98037,
            "density g/cm" : 9.747,
            "melting_point K" : 544.5,
            "boiling_point K" : 1883,
            "atomic_radius pm" : 170,
            "covalent_radius pm" : 146,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 21.3,
            "specific_heat (@20°C J/g mol)" : 0.124,
            "fusion_heat (kJ/mol)" : 11.00,
            "evaporation_heat (kJ/mol)" : 172.0,
            "thermal_conductivity (@25°C W/m K) " : 7.9,
            "pauling_negativity" : 2.02,
            "first_ionizing kJ/mol" : 702.9,
            "oxidation_states" : "5, 3",
            "electronic_configuration" : "[Xe]4f¹5d¹6s²6p³",
            "lattice_structure" : "RHL",
            "lattice_constant ang" : 4.750
        },
        "Polonium": {
            "symbol" : "Po",
            "atomic_number" : 84,
            "atomic_weight" : 208.9824,
            "density g/cm" : 9.32,
            "melting_point K" : 527,
            "boiling_point K" : 1235,
            "atomic_radius pm" : 176,
            "covalent_radius pm" : 146,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 22.7,
            "specific_heat (@20°C J/g mol)" : 0.125,
            "fusion_heat (kJ/mol)" : "(10)",
            "evaporation_heat (kJ/mol)" : "(102.9)",
            "thermal_conductivity (@25°C W/m K) " : "-",
            "pauling_negativity" : 2.0,
            "first_ionizing kJ/mol" : 813.1,
            "oxidation_states" : "6, 4, 2",
            "electronic_configuration" : "[Xe]4f¹5d¹6s²6p",
            "lattice_structure" : "SC",
            "lattice_constant ang" : 3.350
        },
        "Astatine": {
            "symbol" : "At",
            "atomic_number" : 85,
            "atomic_weight" : 209.9871,
            "density g/cm" : "n/a",
            "melting_point K" : 575,
            "boiling_point K" : 610,
            "atomic_radius pm" : "-",
            "covalent_radius pm" : "(145)",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "-",
            "specific_heat (@20°C J/g mol)" : "-",
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : "-",
            "thermal_conductivity (@25°C W/m K) " : "-",
            "pauling_negativity" : 2.2,
            "first_ionizing kJ/mol" : 916.3,
            "oxidation_states" : "7, 5, 3, 1, -1",
            "electronic_configuration" : "[Xe]4f¹5d¹6s²6p",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Radon": {
            "symbol" : "Rn",
            "atomic_number" : 86,
            "atomic_weight" : 222.0176,
            "density g/cm" : "4.4 (@ -62°C)",
            "melting_point K" : 202,
            "boiling_point K" : 211.4,
            "atomic_radius pm" : "-",
            "covalent_radius pm" : "-",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "-",
            "specific_heat (@20°C J/g mol)" : 0.094,
            "fusion_heat (kJ/mol)" : "-",
            "evaporation_heat (kJ/mol)" : 18.1,
            "thermal_conductivity (@25°C W/m K) " : 0.0036,
            "pauling_negativity" : "-",
            "first_ionizing kJ/mol" : 1036.5,
            "oxidation_states" : "-",
            "electronic_configuration" : "[Xe]4f¹5d¹6s²6p",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : "n/a"
        },
        "Francium": {
            "symbol" : "Fr",
            "atomic_number" : 87,
            "atomic_weight" : 223.0197,
            "density g/cm" : "n/a",
            "melting_point K" : 300,
            "boiling_point K" : 950,
            "atomic_radius pm" : "-",
            "covalent_radius pm" : "-",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "-",
            "specific_heat (@20°C J/g mol)" : "-",
            "fusion_heat (kJ/mol)" : 15,
            "evaporation_heat (kJ/mol)" : "-",
            "thermal_conductivity (@25°C W/m K) " : "-",
            "pauling_negativity" : 0.7,
            "first_ionizing kJ/mol" : "~375",
            "oxidation_states" : 2,
            "electronic_configuration" : "[Rn]7s¹",
            "lattice_structure" : "BCC",
            "lattice_constant ang" : "n/a"
        },
        "Radium": {
            "symbol" : "Ra",
            "atomic_number" : 88,
            "atomic_weight" : 226.0254,
            "density g/cm" : "(5.5)",
            "melting_point K" : 973,
            "boiling_point K" : 1413,
            "atomic_radius pm" : "-",
            "covalent_radius pm" : "-",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 45.0,
            "specific_heat (@20°C J/g mol)" : 0.120,
            "fusion_heat (kJ/mol)" : "(9.6)",
            "evaporation_heat (kJ/mol)" : "(113)",
            "thermal_conductivity (@25°C W/m K) " : "(18.6)",
            "pauling_negativity" : 0.9,
            "first_ionizing kJ/mol" : 509.0,
            "oxidation_states" : 2,
            "electronic_configuration" : "[Rn]7s²",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Actinium": {
            "symbol" : "Ac",
            "atomic_number" : 89,
            "atomic_weight" : 227.0278,
            "density g/cm" : "n/a",
            "melting_point K" : 1320,
            "boiling_point K" : 3470,
            "atomic_radius pm" : 188,
            "covalent_radius pm" : "-",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 22.54,
            "specific_heat (@20°C J/g mol)" : "-",
            "fusion_heat (kJ/mol)" : "(10.5)",
            "evaporation_heat (kJ/mol)" : "(292.9)",
            "thermal_conductivity (@25°C W/m K) " : "-",
            "pauling_negativity" : 1.1,
            "first_ionizing kJ/mol" : 665.5,
            "oxidation_states" : 3,
            "electronic_configuration" : "[Rn]6d¹7s²",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 5.310
        },
        "Thorium": {
            "symbol" : "Th",
            "atomic_number" : 90,
            "atomic_weight" : 232.0381,
            "density g/cm" : 11.78,
            "melting_point K" : 2028,
            "boiling_point K" : 5060,
            "atomic_radius pm" : 180,
            "covalent_radius pm" : 165,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 19.8,
            "specific_heat (@20°C J/g mol)" : 0.113,
            "fusion_heat (kJ/mol)" : 16.11,
            "evaporation_heat (kJ/mol)" : 513.7,
            "thermal_conductivity (@25°C W/m K) " : "(54.0)",
            "pauling_negativity" : 1.3,
            "first_ionizing kJ/mol" : 670.4,
            "oxidation_states" : 4,
            "electronic_configuration" : "[Rn]5f6d¹7s²",
            "lattice_structure" : "FCC",
            "lattice_constant ang" : 5.080
        },
        "Protactinium": {
            "symbol" : "Pa",
            "atomic_number" : 91,
            "atomic_weight" : 231.03588,
            "density g/cm" : 15.37,
            "melting_point K" : 2113,
            "boiling_point K" : 4300,
            "atomic_radius pm" : 161,
            "covalent_radius pm" : "-",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 15.0,
            "specific_heat (@20°C J/g mol)" : 0.121,
            "fusion_heat (kJ/mol)" : 16.7,
            "evaporation_heat (kJ/mol)" : 481.2,
            "thermal_conductivity (@25°C W/m K) " : "-",
            "pauling_negativity" : 1.5,
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "5, 4",
            "electronic_configuration" : "[Rn]5f²6d¹7s²",
            "lattice_structure" : "TET",
            "lattice_constant ang" : 3.920
        },
        "Uranium": {
            "symbol" : "U",
            "atomic_number" : 92,
            "atomic_weight" : 238.0289,
            "density g/cm" : 19.05,
            "melting_point K" : 1405.5,
            "boiling_point K" : 4018,
            "atomic_radius pm" : 138,
            "covalent_radius pm" : 142,
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 12.5,
            "specific_heat (@20°C J/g mol)" : 0.115,
            "fusion_heat (kJ/mol)" : 12.6,
            "evaporation_heat (kJ/mol)" : 417,
            "thermal_conductivity (@25°C W/m K) " : 27.5,
            "pauling_negativity" : 1.38,
            "first_ionizing kJ/mol" : 686.4,
            "oxidation_states" : "6, 5, 4, 3",
            "electronic_configuration" : "[Rn]5f³6d¹7s²",
            "lattice_structure" : "ORC",
            "lattice_constant ang" : 2.850
        },
        "Neptunium": {
            "symbol" : "Np",
            "atomic_number" : 93,
            "atomic_weight" : 237.048,
            "density g/cm" : 20.25,
            "melting_point K" : 913,
            "boiling_point K" : 4175,
            "atomic_radius pm" : 130,
            "covalent_radius pm" : "-",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 21.1,
            "specific_heat (@20°C J/g mol)" : "-",
            "fusion_heat (kJ/mol)" : "(9.6)",
            "evaporation_heat (kJ/mol)" : 336,
            "thermal_conductivity (@25°C W/m K) " : "(6.3)",
            "pauling_negativity" : 1.36,
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "6, 5, 4, 3",
            "electronic_configuration" : "[Rn]5f6d¹7s²",
            "lattice_structure" : "ORC",
            "lattice_constant ang" : 4.720
        },
        "Plutonium": {
            "symbol" : "Pu",
            "atomic_number" : 94,
            "atomic_weight" : 244.0642,
            "density g/cm" : 19.84,
            "melting_point K" : 914,
            "boiling_point K" : 3505,
            "atomic_radius pm" : 151,
            "covalent_radius pm" : "-",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "-",
            "specific_heat (@20°C J/g mol)" : "-",
            "fusion_heat (kJ/mol)" : 2.8,
            "evaporation_heat (kJ/mol)" : 343.5,
            "thermal_conductivity (@25°C W/m K) " : "(6.7)",
            "pauling_negativity" : 1.28,
            "first_ionizing kJ/mol" : 491.9,
            "oxidation_states" : "6, 5, 4, 3",
            "electronic_configuration" : "[Rn]5f6d7s²",
            "lattice_structure" : "MCL",
            "lattice_constant ang" : "n/a"
        },
        "Americium": {
            "symbol" : "Am",
            "atomic_number" : 95,
            "atomic_weight" : 243.0614,
            "density g/cm" : 13.67,
            "melting_point K" : 1267,
            "boiling_point K" : 2880,
            "atomic_radius pm" : 173,
            "covalent_radius pm" : "-",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 20.8,
            "specific_heat (@20°C J/g mol)" : "-",
            "fusion_heat (kJ/mol)" : "(10.0)",
            "evaporation_heat (kJ/mol)" : 238.5,
            "thermal_conductivity (@25°C W/m K) " : "-",
            "pauling_negativity" : 1.3,
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "6, 5, 4, 3",
            "electronic_configuration" : "[Rn]5f6d7s²",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Curium": {
            "symbol" : "Cm",
            "atomic_number" : 96,
            "atomic_weight" : 247.0703,
            "density g/cm" : 13.51,
            "melting_point K" : 1340,
            "boiling_point K" : "n/a",
            "atomic_radius pm" : 299,
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : 18.28,
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : 1.3,
            "first_ionizing kJ/mol" : "(580)",
            "oxidation_states" : "4, 3",
            "electronic_configuration" : "[Rn]5f6d¹7s²",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/A"
        },
        "Berkelium": {
            "symbol" : "Bk",
            "atomic_number" : 97,
            "atomic_weight" : 247.0703,
            "density g/cm" : 13.25,
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : 297,
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : 1.3,
            "first_ionizing kJ/mol" : "(600)",
            "oxidation_states" : "4, 3",
            "electronic_configuration" : "[Rn]5f6d7s²",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Californium": {
            "symbol" : "Cf",
            "atomic_number" : 98,
            "atomic_weight" : 251.0796,
            "density g/cm" : 15.1,
            "melting_point K" : 900,
            "boiling_point K" : "n/a",
            "atomic_radius pm" : 295,
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : 1.3,
            "first_ionizing kJ/mol" : "(610)",
            "oxidation_states" : "4, 3",
            "electronic_configuration" : "[Rn]5f¹6d7s²",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Einsteinium": {
            "symbol" : "Es",
            "atomic_number" : 99,
            "atomic_weight" : 252.083,
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : 1130,
            "atomic_radius pm" : 292,
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : 1.3,
            "first_ionizing kJ/mol" : "(620)",
            "oxidation_states" : 3,
            "electronic_configuration" : "[Rn]5f¹¹6d7s²",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Fermium": {
            "symbol" : "Fm",
            "atomic_number" : 100,
            "atomic_weight" : 257.0951,
            "density g/cm" : "n/a",
            "melting_point K" : 1800,
            "boiling_point K" : "n/a",
            "atomic_radius pm" : 290,
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : 1.3,
            "first_ionizing kJ/mol" : "(630)",
            "oxidation_states" : 3,
            "electronic_configuration" : "[Rn]5f¹²6d7s²",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Mendelevium": {
            "symbol" : "Md",
            "atomic_number" : 101,
            "atomic_weight" : 258.1,
            "density g/cm" : "n/a",
            "melting_point K" : 1100,
            "boiling_point K" : "n/a",
            "atomic_radius pm" : 287,
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : 1.3,
            "first_ionizing kJ/mol" : "(635)",
            "oxidation_states" : 3,
            "electronic_configuration" : "[Rn]5f¹³6d7s²",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Nobelium": {
            "symbol" : "No",
            "atomic_number" : 102,
            "atomic_weight" : 259.1009,
            "density g/cm" : "n/a",
            "melting_point K" : 1100,
            "boiling_point K" : "n/a",
            "atomic_radius pm" : 285,
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : 1.3,
            "first_ionizing kJ/mol" : "(640)",
            "oxidation_states" : "3,2",
            "electronic_configuration" : "[Rn]5f¹6d7s²",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Lawrencium": {
            "symbol" : "Lr",
            "atomic_number" : 103,
            "atomic_weight" : 262.11,
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : 282,
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : 3,
            "electronic_configuration" : "[Rn]5f¹6d¹7s²",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Rutherfordium": {
            "symbol" : "Rf",
            "atomic_number" : 104,
            "atomic_weight" : "[261]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "-",
            "electronic_configuration" : "[Rn]5f¹6d²7s²",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Dubnium": {
            "symbol" : "Db",
            "atomic_number" : 105,
            "atomic_weight" : "[262]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "-",
            "electronic_configuration" : "[Rn]5f¹6d³6s²",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Seaborgium": {
            "symbol" : "Sg",
            "atomic_number" : 106,
            "atomic_weight" : "[266]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "-",
            "electronic_configuration" : "[Rn]5f¹6d¹7s²",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Bohrium": {
            "symbol" : "Bh",
            "atomic_number" : 107,
            "atomic_weight" : "[264]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "n/a",
            "electronic_configuration" : "n/a",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Hassium": {
            "symbol" : "Hs",
            "atomic_number" : 108,
            "atomic_weight" : "[269]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "n/a",
            "electronic_configuration" : "n/a",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Meitnerium": {
            "symbol" : "Mt",
            "atomic_number" : 109,
            "atomic_weight" : "[278]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "n/a",
            "electronic_configuration" : "n/a",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Darmstadtium": {
            "symbol" : "Ds",
            "atomic_number" : 110,
            "atomic_weight" : "[281]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "n/a",
            "electronic_configuration" : "n/a",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Roentgenium": {
            "symbol" : "Rg",
            "atomic_number" : 111,
            "atomic_weight" : "[281]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "n/a",
            "electronic_configuration" : "n/a",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Copernicium": {
            "symbol" : "Cn",
            "atomic_number" : 112,
            "atomic_weight" : "[285]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "n/a",
            "electronic_configuration" : "n/a",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Ununtrium": {
            "symbol" : "Uut",
            "atomic_number" : 113,
            "atomic_weight" : "[286]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "n/a",
            "electronic_configuration" : "n/a",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Flerovium": {
            "symbol" : "Fl",
            "atomic_number" : 114,
            "atomic_weight" : "[289]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "n/a",
            "electronic_configuration" : "n/a",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Ununpentium": {
            "symbol" : "Uup",
            "atomic_number" : 115,
            "atomic_weight" : "[289]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "n/a",
            "electronic_configuration" : "n/a",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Livermorium": {
            "symbol" : "Lv",
            "atomic_number" : 116,
            "atomic_weight" : "[293]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "n/a",
            "electronic_configuration" : "n/a",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Ununseptium": {
            "symbol" : "Uus",
            "atomic_number" : 117,
            "atomic_weight" : "[294]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "n/a",
            "electronic_configuration" : "n/a",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        },
        "Ununoctium": {
            "symbol" : "Uuo",
            "atomic_number" : 118,
            "atomic_weight" : "[294]",
            "density g/cm" : "n/a",
            "melting_point K" : "n/a",
            "boiling_point K" : "n/a",
            "atomic_radius pm" : "n/a",
            "covalent_radius pm" : "n/a",
            "ionic_radius pm" : "",
            "atomic_volume cm3/mol" : "n/a",
            "specific_heat (@20°C J/g mol)" : "n/a",
            "fusion_heat (kJ/mol)" : "n/a",
            "evaporation_heat (kJ/mol)" : "n/a",
            "thermal_conductivity (@25°C W/m K) " : "n/a",
            "pauling_negativity" : "n/a",
            "first_ionizing kJ/mol" : "n/a",
            "oxidation_states" : "n/a",
            "electronic_configuration" : "n/a",
            "lattice_structure" : "n/a",
            "lattice_constant ang" : "n/a"
        }
    };

    var periodicTable = $("<div>").appendTo("body");
    periodicTable.attr("title", $._("Periodic table of the elements"));
    periodicTable.dialog({
        autoOpen: false,
        show: "fade",
        hide: "fade",
        modal: "true",
        width: 900
    });
    // Disable the scratchpad so people don't try drawing on top of the "show
    // periodic table" button instead of clicking it.
    Khan.scratchpad.disable();
    $("#show-periodic-table").on("click", function() {
        periodicTable.dialog("open");
        return false;
    });


    var table = $("<table>").appendTo(periodicTable);
    table.addClass("periodic-table");

    var layout = [
        [ 1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2],
        [ 3,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  6,  7,  8,  9, 10],
        [11, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 14, 15, 16, 17, 18],
        [19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36],
        [37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54],
        [55, 56, 57, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86],
        [87, 88, 89, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118],
        [ 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0],
        [ 0,  0,  0, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71,  0],
        [ 0,  0,  0, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 0]];

    _.each(layout, function(row) {
        var tr = $("<tr>").appendTo(table);
        _.each(row, function(atomicNum) {
            var td = $("<td>").appendTo(tr);
            if (atomicNum !== 0) {
                td.addClass("element");
                var element = _.find(elements, function(element) { return element.atomic_number === atomicNum; });
                var weight = isNaN(element.atomic_weight) ? element.atomic_weight : KhanUtil.localeToFixed(element.atomic_weight, 2);
                $("<div>").appendTo(td).text(atomicNum).addClass("atomic-num");
                $("<div>").appendTo(td).text(element.symbol).addClass("symbol");
                $("<div>").appendTo(td).text(weight).addClass("weight");
            }
        });
    });

    $.extend(KhanUtil, {
        molarMass: function(symbol) {
            var element = _.find(elements, function(element) { return element.symbol === symbol; });
            return KhanUtil.roundTo(2, element.atomic_weight);
        }
    });
};

});
